<?php 
if ( ! defined( 'ABSPATH' ) ) exit;
// [random_post] - menampilkan 1 post acak lengkap dengan konten
function echi_random_post_shortcode() {
    $query = new WP_Query([
        'post_type'      => 'post',
        'post_status'    => 'publish',
        'posts_per_page' => 1,
        'orderby'        => 'rand',
        'ignore_sticky_posts' => true,
    ]);

    //if (!$query->have_posts()) {
    //    return '<p>Tidak ada post ditemukan.</p>';
    //}

    ob_start();
    
    while ($query->have_posts()) {
        $query->the_post(); 
        the_content();
    }
    
    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('random_post', 'echi_random_post_shortcode');

// Prevent caching for random post pages
function disable_cache_for_random_post() {
    if ( has_shortcode(get_the_content(), 'random_post') ) {
        nocache_headers();
    }
}
add_action('wp', 'disable_cache_for_random_post');