<?php 
  

function auto_seo(){
//ini_set('display_errors', ERRORS); 
global $post, $paged, $opt_themes, $wpdb, $query, $wp_query;

$blogname			= get_option("blogname");
$siteurls			= get_option("siteurl");
$blogemail			= get_option("admin_email");
$blogdesc			= get_option("blogdescription");
$sitelangs			= get_bloginfo("language");
$no_images			= $opt_themes['img_json_seo']['url'];

echo '<!--[ Theme Designer ]-->'.PHP_EOL;
echo '<meta name="designer" content="'.EXTHEMES_AUTHOR.'" />'.PHP_EOL;
echo '<meta name="themes" content="'.THEMES_NAMES.'" />'.PHP_EOL;
echo '<meta name="version" content="'.VERSION.'" />'.PHP_EOL; 
echo '<!--[ end Theme Designer ]-->'.PHP_EOL.PHP_EOL;

if(get_post_meta( get_the_ID(), 'wp_GP_ID', true )) {  
$the_title			= ucwords(get_post_meta( get_the_ID(), 'wp_title_GP', true ));
} else { 
$the_title			= get_the_title();
}

if(!empty(get_post()->post_content)){
$the_content		= trim(strip_tags( get_post()->post_content) );
$the_content		= str_replace( array("\n", "\r", "\t"), ' ', $the_content );
$the_content		= str_replace( array( "/<[^>]*>/", "\\n", "\\r", "\\t" ), '', $the_content);
$the_content		= mb_substr( $the_content, 0, 160, 'utf8' );
} else {
$the_content		= '';
}

if(get_the_category(get_the_ID())){
	
$catlist			= get_the_category(get_the_ID());
$cat_name			= array();
foreach ($catlist as $category){
    $cat_name[] 	= $category->cat_name;
}
$the_category		= implode(', ', $cat_name);
}

if(get_the_tags(get_the_ID())){
	
$taglist			= get_the_tags(get_the_ID());
$tag_name			= array();
foreach ($taglist as $tags){
    $tag_name[] 	= $tags->name;
}
$tag_list 			= implode(', ', $tag_name);
if(!empty($the_category)){
$the_tags			= $the_category.', '.$tag_list;
} else {
$the_tags			= '';
}

}

if (has_post_thumbnail()) { 
$urlimagesnya		= wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'full' );
$thumb_id			= get_post_thumbnail_id( get_the_ID() );
//if (get_the_post_thumbnail( get_the_ID() )) { 
$thumb_url			= wp_get_attachment_image_src( $thumb_id, 'full', true );
	$the_thumbnail	= $thumb_url[0];
} else {
	$the_thumbnail	= $no_images;
} 
//print_r($thumb_url);

$authorurl			= get_author_posts_url( $post->post_author );
$author_id			= get_post_field( 'post_author', $post );
$author_name		= get_the_author_meta('user_nicename', $author_id);
$datePublished		= mysql2date( DATE_W3C, $post->post_date_gmt, false );
$dateModified		= mysql2date( DATE_W3C, $post->post_modified_gmt, false );
$the_permalink		= get_the_permalink();  

$image_link			= get_post_meta( get_the_ID(), 'wp_images_GP', true);
$gallery_data		= get_post_meta( get_the_ID(), 'gallery_data', true );

 
if ( get_previous_posts_link() ) {
    echo '<link rel="prev" href="'.get_pagenum_link( $paged - 1 ).'" />'. "\n";
}

if ( get_next_posts_link() ) {
    echo '<link rel="next" href="'.get_pagenum_link( $paged + 1 ).'" />'. "\n";
}

if($opt_themes['seo_meta_tag']){ 
	echo PHP_EOL .'<!--[ '.THEMES_NAMES.' v.'.VERSION.' SEO Meta Keywords Generator for '.get_option("siteurl").' @'.date("Y").', Buy on '.EXTHEMES_ITEMS_URL.' start ]-->'.PHP_EOL.PHP_EOL;
}

if (is_home() || is_front_page() && $opt_themes['seo_meta_tag'] ) { 
	
echo '<!--[ Description and Keyword ]-->'.PHP_EOL;
echo '<meta name="description" content="'.get_option("blogname").' '.get_option("blogdescription").'" />'.PHP_EOL;
//echo '<meta name="keywords" content="'.current(explode(',', get_the_title())).'" />'.PHP_EOL.PHP_EOL;
$custom_query = new WP_Query( array( 'posts_per_page' => '4' ) );
if ( $custom_query->have_posts() ) : 
echo '<meta name="keywords" content="';
while ( $custom_query->have_posts() ) : $custom_query->the_post(); 
echo get_the_title().', ';
endwhile;  
echo '" />'.PHP_EOL;
endif; 
echo '<!--[ End Description and Keyword ]-->'.PHP_EOL.PHP_EOL;

echo '<!--[ Theme Robots Search ]-->'.PHP_EOL;
echo '<meta name="robots" content="max-snippet:-1, max-video-preview:-1, max-image-preview:large" />'.PHP_EOL;
echo '<meta name="googlebot" content="index" />'.PHP_EOL;
echo '<meta name="googlebot-news" content="snippet" />'.PHP_EOL;
echo '<!--[ End Theme Robots Search ]-->'.PHP_EOL.PHP_EOL;

echo '<!--[ Open Graph Facebook ]-->'.PHP_EOL;
echo '<meta property="og:type" content="website" />'.PHP_EOL;
echo '<meta property="og:site_name" content="'.get_option("blogname").'" />'.PHP_EOL;
echo '<meta property="og:url" content="'.home_url( '/' ).'" />'.PHP_EOL;
echo '<meta property="og:title" content="'.trim(get_option("blogname")).' '.trim(get_option("blogdescription")).'" />'.PHP_EOL;
echo '<meta property="og:description" content="'.trim(get_option("blogname")).' '.trim(get_option("blogdescription")).'" />'.PHP_EOL;
echo '<meta property="og:image" content="'.$opt_themes['img_json_seo']['url'].'" />'.PHP_EOL;
echo '<meta property="og:locale" content="'.get_bloginfo("language").'" />'.PHP_EOL;
echo '<!--[ End Graph Facebook ]-->'.PHP_EOL.PHP_EOL;

echo '<!--[ Open Graph Twitter ]-->'.PHP_EOL;
echo '<meta name="twitter:card" content="summary" />'.PHP_EOL;
echo '<meta name="twitter:url" content="'.home_url( '/' ).'" />'.PHP_EOL;
echo '<meta name="twitter:site" content="'.home_url( '/' ).'" />'.PHP_EOL; 
echo '<meta name="twitter:title" content="'.trim(get_option("blogname")).' '.trim(get_option("blogdescription")).'" />'.PHP_EOL;
echo '<meta name="twitter:description" content="'.trim(get_option("blogname")).' '.trim(get_option("blogdescription")).'" />'.PHP_EOL;
echo '<meta name="twitter:image" content="'.$opt_themes['img_json_seo']['url'].'" />'.PHP_EOL;
echo '<!--[ End Graph Twitter ]-->'.PHP_EOL;
 

} elseif (is_single() && 'post' == get_post_type() && !isset( $wp_query->query_vars['download'] ) && !isset( $wp_query->query_vars['file'] ) && $opt_themes['seo_meta_tag'] ) {
 
echo '<!--[ Description and Keyword ]-->'.PHP_EOL;
echo "<meta name='description' content='".strip_tags($the_content)."' />".PHP_EOL;
echo '<meta name="keywords" content="'.$the_tags.'" />'.PHP_EOL;
echo '<!--[ End Description and Keyword ]-->'.PHP_EOL.PHP_EOL;

echo '<!--[ Theme Robots Search ]-->'.PHP_EOL;
echo '<meta name="googlebot" content="index">'.PHP_EOL;
echo '<meta name="googlebot-news" content="snippet">'.PHP_EOL;
echo '<meta name="robots" content="max-snippet:-1, max-video-preview:-1, max-image-preview:large"/>'.PHP_EOL;
echo '<!--[ End Theme Robots Search ]-->'.PHP_EOL.PHP_EOL;

echo '<!--[ Open Graph Facebook ]-->'.PHP_EOL;
echo '<meta property="og:type" content="article" />'.PHP_EOL;
echo '<meta property="og:locale" content="'.get_bloginfo("language").'" />'.PHP_EOL;
echo '<meta property="og:locale:alternate" content="'.get_bloginfo("language").'" />'.PHP_EOL;
echo '<meta property="og:title" content="'.$the_title.'" />'.PHP_EOL;
echo '<meta property="og:image:alt" content="'.$the_title.'" />'.PHP_EOL;
echo '<meta property="og:site_name" content="'.get_option("blogname").'" />'.PHP_EOL;
echo '<meta property="og:image" content="'.$the_thumbnail.'" />'.PHP_EOL;
echo "<meta property='og:description' content='".strip_tags($the_content)."' />".PHP_EOL;
echo '<meta property="article:tag" content="'.$the_tags.'" />'.PHP_EOL;
echo '<meta property="og:url" content="'.$the_permalink.'" />'.PHP_EOL;
echo '<meta property="article:author" content="'.$author_name.'" />'.PHP_EOL;
echo '<meta property="article:author" content="'.$authorurl.'" />'.PHP_EOL;
echo '<meta property="article:publisher" content="'.$authorurl.'" />'.PHP_EOL;
echo '<meta property="article:published_time" content="'.$datePublished.'" />'.PHP_EOL;
echo '<meta property="article:modified_time" content="'.$dateModified.'" />'.PHP_EOL;
echo '<meta property="og:updated_time" content="'.$dateModified.'" />'.PHP_EOL;
echo '<meta property="og:image:secure_url" content="'.$the_thumbnail.'" />'.PHP_EOL;
echo '<!--[ End Graph Facebook ]-->'.PHP_EOL.PHP_EOL;

echo '<!--[ Open Graph Twitter ]-->'.PHP_EOL;
echo '<meta name="twitter:card" content="summary" />'.PHP_EOL;
echo '<meta name="twitter:site" content="'.$the_permalink.'" />'.PHP_EOL;
echo '<meta name="twitter:url" content="'.$the_permalink.'" />'.PHP_EOL;
echo '<meta name="twitter:domain" content="'.$the_permalink.'" />'.PHP_EOL;
echo '<meta name="twitter:title" content="'.$the_title.'" />'.PHP_EOL;
echo "<meta name='twitter:description' content='".strip_tags($the_content)."' />".PHP_EOL;
echo '<meta name="twitter:image" content="'.$the_thumbnail.'" />'.PHP_EOL;
echo '<!--[ End Graph Twitter ]-->'.PHP_EOL;
 
} elseif ( is_page() || is_search() || is_archive() || is_404() || is_tag() || is_author() || is_404() || is_attachment() || is_single() && 'blog' == get_post_type() ) {
echo "";
} 

if($opt_themes['json_seo_on']){ 
?>

<!--[ Theme Json Schema Organization ]-->
<script type="application/ld+json">
{
	"@context": "https://schema.org",
	"@type": "Organization",
	"url": "<?php echo esc_url( home_url( '/' ) ); ?>",
	"logo": "<?php echo $opt_themes['img_json_seo']['url']; ?>",
	"sameAs": [<?php foreach ( (array) $opt_themes['json_url'] as $key => $val ) { ?>"<?php echo $val; ?>",<?php } ?> ""]
}
</script>

<!--[ Theme Json Schema WebSite ]-->
<script type='application/ld+json'>
{
	"@context": "https://schema.org",
	"@type": "WebSite",
	"url": "<?php echo esc_url( home_url( '/' ) ); ?>",
	"name": "<?php echo get_option("blogname"); ?>",
	"alternateName": "<?php echo get_option("blogname"); ?>",
	"potentialAction": {
		"@type": "SearchAction",
		"target": "<?php echo esc_url( home_url( '/' ) ); ?>?s={search_term_string}&max-results=10",
		"query-input": "required name=search_term_string"
	}
}
</script>

<?php } if (is_single() && 'post' == get_post_type() && !isset( $wp_query->query_vars['download'] ) && !isset( $wp_query->query_vars['file'] ) && $opt_themes['json_seo_on'] ) { ?>
<!--[ Theme Json Schema BlogPosting ]-->
<script type='application/ld+json'>
{
	"@context": "http://schema.org",
	"@type": "BlogPosting",
	"mainEntityOfPage": {
		"@type": "WebPage",
		"@id": "<?php echo $the_permalink; ?>"
	},
	"headline": "<?php if( !empty( get_post_meta( $post->ID, 'wp_desck_GP', true ))){ echo mb_substr( get_post_meta( $post->ID, 'wp_desck_GP', true ), 0, 120, 'utf8' ); } else { get_the_title(); } ?>",
	"description": '<?php echo $the_content; ?>',
	"datePublished": "<?php echo $datePublished; ?>",
	"dateModified": "<?php echo $dateModified; ?>",
	"image": {
		"@type": "ImageObject",
		"url": "<?php if (get_the_post_thumbnail( get_the_ID() )) { echo wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' )[0]; } elseif(get_post_meta( get_the_ID(), 'wp_poster_GP', true )) { echo get_post_meta( get_the_ID(), 'wp_poster_GP', true ); } else { echo get_template_directory_uri().'/assets/img/no-image.png'; } ?>",
		"height": <?php echo $thumb_url[2]; ?>,
		"width": <?php echo $thumb_url[1]; ?>
	
	},
	"publisher": {
		"@type": "Organization",
		"name": "<?php echo get_post_meta( get_the_ID(), 'wp_developers_GP', true ); ?>",
		"logo": {
			"@type": "ImageObject",
			"url": "<?php echo $opt_themes['img_json_seo']['url']; ?>",
			"width": <?php echo $thumb_url[1]; ?>, 
			"height": <?php echo $thumb_url[2]; ?> 
		}
	},
	"author": {
		"@type": "Person",
		"name": "<?php echo $author_name; ?>",
		"url": "<?php echo $authorurl; ?>"
	}
}
</script>
 
<?php } ?>

<?php if( is_single() && 'post' == get_post_type() && !isset( $wp_query->query_vars['download'] ) && !isset( $wp_query->query_vars['file'] ) && $opt_themes['json_seo_on'] && get_post_meta( get_the_ID(), 'wp_GP_ID', true ) ) { ?>
 

<?php } ?>


<!--[ Theme Wordpress Rss ]-->
<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
<!--[ <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />  ]--> 
<?php if (is_home() || is_front_page()) {?>
<!--[ <link rel="canonical" href="<?php echo esc_url( home_url( '/' ) ); ?>" /> ]-->
<?php } else { if (is_single() || is_page() ) { ?>
<!--[ <link rel="canonical" href="<?php echo get_permalink(); ?>" /> ]-->
<?php } } if (is_archive()){
global $wp;
$current_url = home_url( $wp->request ) . '/';
?>
<!--[ <link rel="canonical" href="<?php echo $current_url; ?>" /> ]-->
<?php } 
 
if($opt_themes['seo_meta_tag']){
//echo PHP_EOL .'<meta http-equiv="copyright @'.date("Y").' '.$blogemail.'" content="' . strip_tags($blogname) . ' - '.get_option("siteurl").' @'.date("Y").'">'.PHP_EOL;
	echo '<!--[ '.THEMES_NAMES.' v.'.VERSION.' SEO Meta Keywords Generator for '.get_option("siteurl").' @'.date("Y").', Buy on '.EXTHEMES_ITEMS_URL.' end ]-->'.PHP_EOL;
}

echo '<!--[ '.PHP_EOL.'- '.get_option("siteurl").' using '.THEMES_NAMES.' v.'.VERSION.' '.PHP_EOL.'- Buy now on '.EXTHEMES_ITEMS_URL.' '.PHP_EOL.'- Designer and Developer by '.EXTHEMES_AUTHOR.' '.PHP_EOL.'- More Premium Themes Visit Now On '.EXTHEMES_API_URL.' '.PHP_EOL.']-->'.PHP_EOL;

}
add_action( 'wp_head', 'auto_seo', 3); 


function get_breadcrumb_json_ld() {
	$home_url			= get_home_url();
	$post_categories	= get_the_category();
	$first_category		= $post_categories[0];
	$category_url		= get_category_link($first_category->term_id);
  
	$cat				= get_the_category(); 
	$catID				= $cat[0]->cat_ID;
	$parents			= get_ancestors( $catID, 'category' );
	$parents			= array_reverse( $parents );
	$parents[] 			= $catID;
	$position			= 2;
		
	$post_title 	= get_the_title();
	$post_url 		= get_the_permalink();

	$json_ld 	= array(
    '@context' 	=> 'https://schema.org',
    '@type' 	=> 'BreadcrumbList',
	'name' 		=> 'Breadcrumb',
    'itemListElement' => array(
		array(
			'@type' 	=> 'ListItem',
			'position' 	=> 1,
			'name' 		=> 'Home',
			'item' 		=> array(
				'@id'	=> $home_url,          
			),
		),
 
		array(
			'@type' 	=> 'ListItem',
			'position' 	=> 2,
			'name' 		=> $first_category->name,
			'item' 		=> array(
				'@id'	=> $category_url,          
			),
		),
		
		array(
			'@type' 	=> 'ListItem',
			'position' 	=> 3,
			'name' 		=> get_the_title(),
			'item' 		=> array(
				'@id' 	=> get_the_permalink(),          
			),
		),
		
    ),
  );

  //return json_encode($json_ld, JSON_UNESCAPED_SLASHES);
  return json_encode($json_ld);
}

//Output JSON LD to the footer
function output_breadcrumb_json_ld() {
	global $opt_themes;
	if (is_single() && 'post' == get_post_type() && $opt_themes['breadcrumb_seo_on'] ) { 

    $json_ld = get_breadcrumb_json_ld();
echo PHP_EOL.'<!--[ Theme Json Schema breadcrumb ]-->
<script type="application/ld+json">
' . $json_ld . '
</script>
<!--[ End Theme Json Schema breadcrumb ]-->'.PHP_EOL.PHP_EOL;

	}
}
//add_action('wp_head', 'output_breadcrumb_json_ld', 10, 1); 

