<?php

/*-----------------------------------------------------------------------------------*/
/*  Home Widget
/*-----------------------------------------------------------------------------------*/
class mdn_homes_widget_ extends WP_Widget {
    public function __construct() {
        $widget_ops = array(
            'classname'   => 'median-home-widgets',
            'description' => __( 'Display Post by Selected Categorie on Home', TEXT_DOMAIN ),
        );
        parent::__construct( 'median-home-widgets', __( '(Plus UI) Home Categorie', TEXT_DOMAIN ), $widget_ops );
    }
    public function widget( $args, $instance ) {
        $widget_id			= $this->id_base . '-' . $this->number;
        $title				= apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base ); 
        $category_ids		= ( ! empty( $instance['category_ids'] ) ) ? array_map( 'absint', $instance['category_ids'] ) : array( 0 );
        $number_posts		= ( ! empty( $instance['number_posts'] ) ) ? absint( $instance['number_posts'] ) : absint( 5 );
        $link_title			= ( ! empty( $instance['link_title'] ) ) ? esc_url( $instance['link_title'] ) : '';
		?>
		<div class="widget HTML" id="HTML2">
		<?php if ($link_title) {?>
		<h2 class='title dt'><a style="color: unset !important;" href="<?php echo esc_url($link_title); ?>" title="<?php echo $title; ?>" ><?php echo $title; ?></a></h2>
		<?php } else { ?>
		<h2 class='title dt'><?php echo $title; ?></h2>		
		<?php }  
		if ( in_array( 0, $category_ids, true ) ) {
            $category_ids = array( 0 );
        }
	
		$args = array(
				'posts_per_page'			=> $number_posts,
				'post_type'					=> 'post',
				'no_found_rows'				=> true,
				'post_status'				=> 'publish', 
				'orderby'					=> $instance['orderby'],
				'update_post_term_cache'	=> false,
				'update_post_meta_cache'	=> false,
		);

		if ( ! in_array( 0, $category_ids, true ) ) {
			$args['category__in'] = $category_ids;
		} 
			
		if( $instance['orderby'] == 'views' ){
			$args = array(
				'posts_per_page'	=> $instance['number_posts'],
				'post_type'			=> 'post',
				'order'				=> 'DESC',
				'orderby'			=> 'meta_value_num',
				'meta_key'			=> 'post_views_count',
				'ignore_sticky_posts' => true
			);
		}

		if( isset($instance['orderdate']) && $instance['orderdate'] != 'alltime' ){
				$year		= date('Y');
				$month		= absint( date('m') );
				$week		= absint( date('W') );
				
				$args['year']	= $year;

				if( $instance['orderdate'] == 'pastmonth' ){
					$args['monthnum'] = $month - 1;
				}
				if( $instance['orderdate'] == 'pastweek' ){
					$args['w'] = $week - 1;
				}
				if( $instance['orderdate'] == 'pastyear' ){
					unset( $args['year'] );
					$today = getdate();
					$args['date_query'] = array(
						array(
							'after' => $today[ 'month' ] . ' 1st, ' . ($today[ 'year' ] - 2)
						)
					);
				}
		}

		if( isset($instance['orderdate']) && $instance['orderdate'] == 'bydays' && isset($instance['days_amount']) ){
			$args['year'] = '';
			$days_amount = absint( $instance['days_amount'] ); 
			if( $days_amount > 0 ){
			$days_string = "-$days_amount days";
				$args['date_query'] = array(
					'after'		=> date('Y-m-d', strtotime( $days_string ) ),
					'inclusive'	=> true,
					'column'	=> 'post_date'
				);
			}
		}

        $rp = new WP_Query( apply_filters( 'median_homes_widget__widget_posts_args', $args ) );
		?>
		<div class="ctgry loaded">
		<div class='blogPts cPst'>
		<?php while ( $rp->have_posts() ) : $rp->the_post();
		
		set_query_var( 'in', $instance['in'] ); 
		set_query_var( 'published', $instance['published'] ); 
		set_query_var( 'readmore', $instance['readmore'] ); 
		set_query_var( 'show_desc', $instance['show_desc'] ); 
		get_template_part('loop/item.home');
		endwhile; ?>
		<?php wp_reset_postdata(); ?>
		</div>
		</div>	
		<?php if ($link_title) { ?>		
		<div class="blogPg">
		<a aria-label="<?php echo $instance['more_view']; ?>" data-text="<?php echo $instance['more_view']; ?>" href="<?php echo $link_title; ?>"></a>
		</div>
		<?php } ?>
		</div>
		 
        <?php
    }
    
    public function update( $new_instance, $old_instance ) {
        $instance     = $old_instance;
        $new_instance = wp_parse_args(
            (array) $new_instance,
            array(
                'title'             => '',
                'link_title'        => '',
                'category_ids'      => array( 0 ), 
                'number_posts'      => 3,
                'more_view'			=> '',
                'orderby'			=> 'date',
                'orderdate'			=> 'alltime',
                'days_amount'		=> 30,
				'show_desc'			=> false,
				'readmore'			=> '',
				'in'				=> '',
				'published'			=> '',
            )
        );
        $instance['title']			= sanitize_text_field( $new_instance['title'] );
        $instance['link_title']		= esc_url( $new_instance['link_title'] );
        $instance['category_ids']	= array_map( 'absint', $new_instance['category_ids'] ); 
        $instance['number_posts']	= absint( $new_instance['number_posts'] );
        $instance['more_view']		= sanitize_text_field( $new_instance['more_view'] );
		$instance['orderby']		= $new_instance['orderby'];
		$instance['orderdate']		= $new_instance['orderdate'];
		$instance['days_amount']	= (int) $new_instance['days_amount'];
		$instance['show_desc']		= (bool) $new_instance['show_desc'];
		$instance['readmore']		= strip_tags( $new_instance[ 'readmore' ] ); 
		$instance['in']				= strip_tags( $new_instance[ 'in' ] ); 
		$instance['published']		= strip_tags( $new_instance[ 'published' ] ); 
			
        if ( in_array( 0, $instance['category_ids'], true ) ) {
            $instance['category_ids'] = array( 0 );
        }
        return $instance;
    }
	
    public function form( $instance ) {
        $instance = wp_parse_args(
            (array) $instance,
            array(
                'title'             => __( 'Home Widget', TEXT_DOMAIN ),
                'link_title'        => home_url( '/categories' ),
                'category_ids'      => array( 0 ), 
                'number_posts'      => 3,
                'orderby'			=> 'date',
                'orderdate'			=> 'alltime',
                'days_amount'		=> 30,
                'more_view'			=> 'More View',
				'show_desc'			=> false,
				'readmore'			=> 'Read more',
				'in'				=> 'in',
				'published'			=> 'Published',
            )
        );
        $title				= sanitize_text_field( $instance['title'] );
        $link_title			= esc_url( $instance['link_title'] );
        $category_ids		= array_map( 'absint', $instance['category_ids'] );
        $number_posts		= absint( $instance['number_posts'] );
        $more_view			= sanitize_text_field( $instance['more_view'] );
		$days_amount		= isset( $instance['days_amount'] ) ? absint( $instance['days_amount'] ) : 30;
		$show_desc			= (bool) $instance['show_desc']; 
		$in					= $instance['in']; 
		$published			= $instance['published']; 
		$readmore			= $instance['readmore']; 
        
        $categories			= get_categories(
					array(
						'hide_empty'   => 0,
						'hierarchical' => 1,
					)
        );
        $number_of_cats			= count( $categories );
        $number_of_rows			= ( 10 > $number_of_cats ) ? $number_of_cats + 1 : 10;
        if ( in_array( 0, $category_ids, true ) ) {
            $category_ids		= array( 0 );
        }
        $selection_category  = sprintf(
            '<select name="%s[]" id="%s" class="widefat " multiple="multiple" size="%d" >',
            $this->get_field_name( 'category_ids' ),
            $this->get_field_id( 'category_ids' ),
            $number_of_rows
        );
        $selection_category .= "\n";
        $cat_list = array();
        if ( 0 < $number_of_cats ) {
            while ( $categories ) {
                if ( 0 === $categories[0]->parent ) {
                    $current_entry = array_shift( $categories );
                    $cat_list[] = array(
                        'id'    => absint( $current_entry->term_id ),
                        'name'  => esc_html( $current_entry->name ),
                        'depth' => 0,
                    );
                    continue;
                }
                $parent_index = $this->get_cat_parent_index( $cat_list, $categories[0]->parent );
                if ( false === $parent_index ) {
                    $current_entry = array_shift( $categories );
                    $categories[] = $current_entry;
                    continue;
                }
                $depth = $cat_list[ $parent_index ]['depth'] + 1;
                $new_index = $parent_index + 1;
                foreach ( $cat_list as $entry ) {
                    if ( $depth <= $entry['depth'] ) {
                        $new_index = $new_index++;
                        continue;
                    }
                    $current_entry = array_shift( $categories );
                    $end_array  = array_splice( $cat_list, $new_index );
                    $cat_list[] = array(
                        'id'    => absint( $current_entry->term_id ),
                        'name'  => esc_html( $current_entry->name ),
                        'depth' => $depth,
                    );
                    $cat_list   = array_merge( $cat_list, $end_array );
                    break;
                }
            }
            
            $selected            = ( in_array( 0, $category_ids, true ) ) ? ' selected="selected"' : '';
            $selection_category .= "\t";
            $selection_category .= '<option value="0"' . $selected . '>' . __( 'All Categories', TEXT_DOMAIN ) . '</option>';
            $selection_category .= "\n";
            foreach ( $cat_list as $category ) {
                $cat_name            = apply_filters( 'gmr_list_cats', $category['name'], $category );
                $pad                 = ( 0 < $category['depth'] ) ? str_repeat( '&ndash;&nbsp;', $category['depth'] ) : '';
                $selection_category .= "\t";
                $selection_category .= '<option value="' . $category['id'] . '"';
                $selection_category .= ( in_array( $category['id'], $category_ids, true ) ) ? ' selected="selected"' : '';
                $selection_category .= '>' . $pad . $cat_name . '</option>';
                $selection_category .= "\n";
            }
        }
       
        $selection_category .= "</select>\n";
        ?>
		<p style="text-align: center;font-weight: bold;">Post Home Selected by Categorie </p>
		<hr />
        <p>
            <label for="<?php echo esc_html( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title:', TEXT_DOMAIN ); ?></label>
        </p> 
        <p>
            <input class="widefat" id="<?php echo esc_html( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
		<hr />
        <p>
            <label for="<?php echo esc_html( $this->get_field_id( 'link_title' ) ); ?>"><?php _e( 'Button Link :', TEXT_DOMAIN ); ?></label>
        </p> 
        <p>
            <input class="widefat" id="<?php echo esc_html( $this->get_field_id( 'link_title' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'link_title' ) ); ?>" type="url" value="<?php echo esc_attr( $link_title ); ?>" />
		<hr />
            <small><?php _e( 'Target url for title (example: http://www.domain.com/target), leave blank if you want using title without link.', TEXT_DOMAIN ); ?></small>
        </p>
		<hr />
        <p>
            <label for="<?php echo esc_html( $this->get_field_id( 'more_view' ) ); ?>"><?php _e( 'Button Title :', TEXT_DOMAIN ); ?></label>
        </p> 
        <p>
            <input class="widefat" id="<?php echo esc_html( $this->get_field_id( 'more_view' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'more_view' ) ); ?>" type="text" value="<?php echo esc_attr( $more_view ); ?>" />
        </p>
		<hr />
		
		<p>
			<label for="<?php echo $this->get_field_id( 'readmore' ); ?>"><b>Title Button </b></label>
		</p> 
		<p>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'readmore' ); ?>" name="<?php echo $this->get_field_name( 'readmore' ); ?>" value="<?php echo esc_attr( $readmore ); ?>" />
		</p>
		<hr />
		<p>
			<label for="<?php echo $this->get_field_id( 'in' ); ?>"><b>Title IN </b></label>
		</p> 
		<p>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'in' ); ?>" name="<?php echo $this->get_field_name( 'in' ); ?>" value="<?php echo esc_attr( $in ); ?>" />
		</p>
		<hr />
		<p>
			<label for="<?php echo $this->get_field_id( 'published' ); ?>"><b>Title Published </b></label>
		</p> 
		<p>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'published' ); ?>" name="<?php echo $this->get_field_name( 'published' ); ?>" value="<?php echo esc_attr( $published ); ?>" />
		</p>
		<hr />
		
        <p>
            <label for="<?php echo esc_html( $this->get_field_id( 'category_ids' ) ); ?>"><?php _e( 'Selected categories', TEXT_DOMAIN ); ?></label>
        </p> 
        <p>
            <?php echo $selection_category; ?>
        
        </p> 
        <p>
            <small><?php _e( 'Click on the categories with pressed CTRL key to select multiple categories. If All Categories was selected then other selections will be ignored.', TEXT_DOMAIN ); ?></small>
        </p>
		<hr />
        <p>
            <label for="<?php echo esc_html( $this->get_field_id( 'number_posts' ) ); ?>"><?php _e( 'Number post', TEXT_DOMAIN ); ?></label>
        </p> 
        <p>
            <input class="widefat" id="<?php echo esc_html( $this->get_field_id( 'number_posts' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'number_posts' ) ); ?>" type="number" value="<?php echo esc_attr( $number_posts ); ?>" />
        </p>
		<hr />
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $show_desc ); ?> id="<?php echo esc_html( $this->get_field_id( 'show_desc' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'show_desc' ) ); ?>" /><label for="<?php echo esc_html( $this->get_field_id( 'show_desc' ) ); ?>"><?php _e( 'Show Excerpt?', TEXT_DOMAIN ); ?></label>
		</p>
		<hr />
		<p>
			<label for="<?php echo $this->get_field_id('orderby'); ?>"><?php _e('Mode:',  TEXT_DOMAIN ) ?> </label>
        </p>
        <p>
			<select id="<?php echo $this->get_field_id('orderby'); ?>" name="<?php echo $this->get_field_name('orderby'); ?>">
			<option <?php if ($instance['orderby'] == 'date') echo 'selected="selected"'; ?> value="date"><?php _e('Recent Posts',  TEXT_DOMAIN ); ?></option>
			<option <?php if ($instance['orderby'] == 'rand') echo 'selected="selected"'; ?> value="rand"><?php _e('Random Posts',  TEXT_DOMAIN ); ?></option>
			<option <?php if ($instance['orderby'] == 'modified') echo 'selected="selected"'; ?> value="modified"><?php _e('Recent Modified ',  TEXT_DOMAIN ); ?></option>
			<option <?php if ($instance['orderby'] == 'views') echo 'selected="selected"'; ?> value="views"><?php _e('Post Views',  TEXT_DOMAIN ); ?></option>
			</select>
		</p>
		<hr />
		<div class="mdn-select-day">
		<p>
			<label for="<?php echo $this->get_field_id('orderdate'); ?>"><?php _e('Date:',  TEXT_DOMAIN ) ?> </label>
        </p>
        <p>
				<select id="<?php echo $this->get_field_id('orderdate'); ?>" name="<?php echo $this->get_field_name('orderdate'); ?>">
				<option <?php if ($instance['orderdate'] == 'alltime') echo 'selected="selected"'; ?> value="alltime"><?php _e('All Time',  TEXT_DOMAIN ); ?></option>
				<option <?php if ($instance['orderdate'] == 'pastyear') echo 'selected="selected"'; ?> value="pastyear"><?php _e('Past Year',  TEXT_DOMAIN ); ?></option>
				<option <?php if ($instance['orderdate'] == 'pastmonth') echo 'selected="selected"'; ?> value="pastmonth"><?php _e('Past Month',  TEXT_DOMAIN ); ?></option>
				<option <?php if ($instance['orderdate'] == 'pastweek') echo 'selected="selected"'; ?> value="pastweek"><?php _e('Past Week',  TEXT_DOMAIN ); ?></option>
				<option <?php if ($instance['orderdate'] == 'bydays') echo 'selected="selected"'; ?> value="bydays"><?php _e('Last "X" days', TEXT_DOMAIN); ?></option>
				</select>
		</p>
		<p class="mdn-days <?php echo $this->get_field_id('orderdate'); ?> <?php if ($instance['orderdate'] != 'bydays') echo 'hidden'; ?>">        
			<label for="<?php echo $this->get_field_id('days_amount'); ?>"><?php _e( 'Number of last days to filter:', TEXT_DOMAIN); ?></label>
			<input id="<?php echo $this->get_field_id('days_amount'); ?>" name="<?php echo $this->get_field_name('days_amount'); ?>" type="text" value="<?php echo $days_amount; ?>" size="1" />
		</p>
		</div>
		<hr />
		<script>
			(function($){
			$(document).ready(function(){
				$('.mdn-select-day').each(function(){
					var container = $(this);
					container.find('select').on('change', function(){
						var value = $(this).val();
						if( value == 'bydays' ){
							container.find('.mdn-days').show();
						}else{
							container.find('.mdn-days').hide();
						}
					});
				});
			});
		})(jQuery);
		</script>
        <?php
    }
    
    private function get_cat_parent_index( $arr, $id ) {
        $len = count( $arr );
        if ( 0 === $len ) {
            return false;
        }
        $id = absint( $id );
        for ( $i = 0; $i < $len; $i++ ) {
            if ( $id === $arr[ $i ]['id'] ) {
                return $i;
            }
        }
        return false;
    }
     
}
add_action( 'widgets_init', function() { register_widget( 'mdn_homes_widget_' ); } );

