<?php

/*-----------------------------------------------------------------------------------*/
/*  Featured Widget
/*-----------------------------------------------------------------------------------*/
class mdn_homes_featured_2_widget_ extends WP_Widget {

/*-----------------------------------------------------------------------------------*/
/*  Widget Setup
/*-----------------------------------------------------------------------------------*/
 
    public function __construct() {
        $widget_ops = array(
            'classname'   => 'median_homes_featured_2_widget_',
            'description' => __( 'Display post on Featured.', TEXT_DOMAIN ),
        );
        parent::__construct( 'median_homes_featured_2_widget_', __( '(Plus UI) Featured ', TEXT_DOMAIN ), $widget_ops );
    }
/*-----------------------------------------------------------------------------------*/
/*  Display Widget
/*-----------------------------------------------------------------------------------*/

function widget($args, $instance) {
    extract($args);
	$title			= ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';
    $featured_post	= isset($instance["featured_post"]) ? $instance["featured_post"] : '';
    $posts			= null;
    $args			=  array(
    'p'                => $featured_post,
    'posts_per_page'   => 1,
    'orderby'          => 'date',
    'order'            => 'DESC',
    'post_type'        => 'post',
    'post_status'      => 'publish',
    'ignore_sticky_posts' => true
    );

    $posts_query = new WP_Query;
    $posts = $posts_query->query($args);
    $unique_block_id = rand(10000, 900000);

    if (!empty($instance['titles'])) {} ?>

	<div class='widget FeaturedPost'>
	<h2 class='title dt'><?php echo $title;?></h2>
	<div class='itemFt' role='feed'>
	<?php
    while ($posts_query->have_posts()) {
		
		set_query_var( 'in', $instance['in'] ); 
		set_query_var( 'published', $instance['published'] ); 
		set_query_var( 'readmore', $instance['readmore'] ); 
		set_query_var( 'show_desc', $instance['show_desc'] ); 
		
	$post_id 		= get_the_ID();
	$posts_query->the_post();
	$categories 	= get_the_category(get_the_ID());  
	global $post, $opt_themes;  
	get_template_part('loop/item.featured');
	}  
	wp_reset_postdata();
	?>
	</div>
	</div>
 
<?php }
/*-----------------------------------------------------------------------------------*/
/*  Update Widget
/*-----------------------------------------------------------------------------------*/

function update( $new_instance, $old_instance ) {
    $instance     = $old_instance;
		$new_instance = wp_parse_args(
			(array) $new_instance,
			array(
				'title'             => '',
				'readmore'			=> '',
				'in'				=> '',
				'published'			=> '',
				'show_desc'			=> false, 
			)
		);
	$instance['title']			= strip_tags( $new_instance[ 'title' ] ); 
	$instance['readmore']		= strip_tags( $new_instance[ 'readmore' ] ); 
	$instance['in']				= strip_tags( $new_instance[ 'in' ] ); 
	$instance['published']		= strip_tags( $new_instance[ 'published' ] ); 
    $instance['featured_post']	= $new_instance['featured_post'];
	$instance['show_desc']		= (bool) $new_instance['show_desc'];
    return $instance;
}

/*-----------------------------------------------------------------------------------*/
/*  Widget Settings (Displays the widget settings controls on the widget panel)
/*-----------------------------------------------------------------------------------*/

function form( $instance ) { 
$instance = wp_parse_args(
			(array) $instance,
			array(
				'title'				=> 'Pinned Post',
				'readmore'			=> 'Read more',
				'in'				=> 'in',
				'published'			=> 'Published',
				'show_desc'			=> false,
			)
		);
		$title			= $instance['title']; 
		$in				= $instance['in']; 
		$published		= $instance['published']; 
		$readmore		= $instance['readmore']; 
		$show_desc		= (bool) $instance['show_desc']; 
		?>

 
<div class="container">		
		<p style="text-align: center;font-weight: bold;">Featured Post </p>
		<hr />
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><b>Title </b></label>
		</p> 
		<p>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<hr />
		<p>
			<label for="<?php echo $this->get_field_id( 'readmore' ); ?>"><b>Title Button </b></label>
		</p> 
		<p>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'readmore' ); ?>" name="<?php echo $this->get_field_name( 'readmore' ); ?>" value="<?php echo esc_attr( $readmore ); ?>" />
		</p>
		<hr />
		<p>
			<label for="<?php echo $this->get_field_id( 'in' ); ?>"><b>Title IN </b></label>
		</p> 
		<p>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'in' ); ?>" name="<?php echo $this->get_field_name( 'in' ); ?>" value="<?php echo esc_attr( $in ); ?>" />
		</p>
		<hr />
		<p>
			<label for="<?php echo $this->get_field_id( 'published' ); ?>"><b>Title Published </b></label>
		</p> 
		<p>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'published' ); ?>" name="<?php echo $this->get_field_name( 'published' ); ?>" value="<?php echo esc_attr( $published ); ?>" />
		</p>
		<hr />
		<p>
			<label><strong>Selected The Post For Featured</strong></label>
		</p>
		<p>    
        <select id="<?php echo esc_attr( $this->get_field_id( 'featured_post' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'featured_post' ) ); ?>">

            <?php 
                $posts_args = array(
					'posts_per_page'		=> 99999,
					'orderby'				=> 'date',
					'order'					=> 'DESC',
					'post_type'				=> 'post',
					'post_status'			=> 'publish',
					'ignore_sticky_posts'	=> true
					);
                $last_entries = get_posts($posts_args);
                foreach ($last_entries as $entry) {
            ?>
                <option value="<?php echo $entry->ID; ?>" <?php if($instance['featured_post']==$entry->ID){ echo 'selected="selected"'; } ?> ><?php echo $entry->post_title; ?></option>
            <?php
                }
            ?>
        </select>
		</p>
		<hr />
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $show_desc ); ?> id="<?php echo esc_html( $this->get_field_id( 'show_desc' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'show_desc' ) ); ?>" /><label for="<?php echo esc_html( $this->get_field_id( 'show_desc' ) ); ?>"><?php _e( 'Show Excerpt?', TEXT_DOMAIN ); ?></label>
		</p>
		<hr />
</div>

<?php } }

function mdn_homes_register_featured_2_widget_() {
    register_widget('mdn_homes_featured_2_widget_');
}
add_action('widgets_init', 'mdn_homes_register_featured_2_widget_');
