<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckWhatsAppConnection
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (! whatsappConnected()) {
            return redirect()->route('client.whatsapp.settings');
        }

        return $next($request);
    }
}
